/* JAlbum tool that strips xmp title from files */
Work.on(TreeCollection.of(selectedObjects).parallelStream().filter(ao -> ao.xmpManager != null))
.titled("Strip xmp title")
.inform("This script strips the xmp title from the xmp section of selected files")
.forEach(ao, counter) -> {
	XmpManager mgr = ao.getXmpManager();
	if (mgr.getTitle() != null) {
		mgr.getXMPMeta().deleteProperty(XmpManager.dc_NS, "dc:title");
		mgr.save();
		counter++;
	}
}
.execute(work) -> {
	// Refresh display
	explorer.context.viewFolder(explorer.context.currentFolder);
	window.statusBar.setText("Processed ${work.processed} objects");
}
.showResult();

